// ab_status_client.js (optionnel, JS pur)
const AB_BACKEND = "https://gp-eff.alwaysdata.net/xdockplus/AB/ab_status_backend.php";

export async function abGetMap() {
  const r = await fetch(AB_BACKEND, { cache: "no-store" });
  if (!r.ok) throw new Error("AB GET failed");
  return r.json(); // { "weTourId": true|false, ... }
}

export async function abSet(tournee, ab) {
  const r = await fetch(AB_BACKEND, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ tournee, ab: !!ab })
  });
  if (!r.ok) throw new Error("AB POST failed");
  return r.json(); // { ok: true, ... }
}
